<div class="row invite-a-friend mt-4" id="invite-a-friend">
    <div class="col-lg-6">
        <div class="card text-heading">
            <div class="card-body mb-3 flex flex-col px-8 py-6">
                <h2 class="mb-[1em]">@lang('How it Works')</h2>
                <p>
                    @lang('Adding and overseeing team members is a straightforward process. Here\'s a quick example to initiate collaboration within seconds.')
                </p>
            </div>
            <div class="card-body flex flex-col px-8 py-6">
                <ol class="mb-3 ml-0 mt-4 list-none p-0">
                    <li class="mb-[18px]">
                        <span
                            class="text-primary me-[1em] inline-flex h-[26px] w-[26px] items-center justify-center rounded-2xl bg-[rgba(var(--tblr-primary-rgb),0.2)]">
                            <svg width="8" height="12" viewBox="0 0 8 12" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M0.522461 12V9.63199H2.98646V3.69599L0.522461 5.45599V2.57599L3.00246 0.799988H5.88246V9.63199H7.88246V12H0.522461Z"
                                    fill="#7A63DF"></path>
                            </svg>
                        </span>
                        @lang('Send an <strong>invitation</strong> link to your team members.')
                    </li>
                    <li class="mb-[18px]">
                        <span
                            class="text-primary me-[1em] inline-flex h-[26px] w-[26px] items-center justify-center rounded-2xl bg-[rgba(var(--tblr-primary-rgb),0.2)]">
                            <svg width="10" height="12" viewBox="0 0 10 12" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M0.400391 12V9.95198L4.11239 6.87998C4.59239 6.48531 4.98172 6.13865 5.28039 5.83998C5.58972 5.53065 5.80839 5.24265 5.93639 4.97598C6.07506 4.70931 6.14439 4.43731 6.14439 4.15998C6.14439 3.78665 6.04306 3.49865 5.84039 3.29598C5.63772 3.09331 5.34439 2.99198 4.96039 2.99198C4.45906 2.99198 4.08039 3.15198 3.82439 3.47198C3.56839 3.79198 3.44039 4.26131 3.44039 4.87998H0.560391C0.560391 3.96265 0.720391 3.18931 1.04039 2.55998C1.37106 1.91998 1.86172 1.43465 2.51239 1.10398C3.16306 0.762647 3.97906 0.59198 4.96039 0.59198C5.87772 0.59198 6.63506 0.746647 7.23239 1.05598C7.84039 1.35465 8.29372 1.77065 8.59239 2.30398C8.89106 2.83731 9.04039 3.45598 9.04039 4.15998C9.04039 4.67198 8.92306 5.16265 8.68839 5.63198C8.45372 6.09065 8.13372 6.52798 7.72839 6.94398C7.33372 7.34931 6.87506 7.75465 6.35239 8.15998L4.41639 9.63198H9.20039V12H0.400391Z"
                                    fill="#7A63DF"></path>
                            </svg>
                        </span>
                        @lang('<strong>Let them register</strong> with their email address.')
                    </li>
                    <li class="mb-[18px]">
                        <span
                            class="text-primary me-[1em] inline-flex h-[26px] w-[26px] items-center justify-center rounded-2xl bg-[rgba(var(--tblr-primary-rgb),0.2)]">
                            <svg width="10" height="13" viewBox="0 0 10 13" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M4.80047 12.208C3.85114 12.208 3.05114 12.0373 2.40047 11.696C1.76047 11.3546 1.28047 10.8853 0.960469 10.288C0.640469 9.69065 0.480469 9.00798 0.480469 8.23998H3.36047C3.36047 8.76265 3.4778 9.15731 3.71247 9.42398C3.9578 9.67998 4.35247 9.80798 4.89647 9.80798C5.34447 9.80798 5.67514 9.69598 5.88847 9.47198C6.11247 9.23731 6.22447 8.92798 6.22447 8.54398C6.22447 8.13865 6.11247 7.82931 5.88847 7.61598C5.66447 7.40265 5.3018 7.29598 4.80047 7.29598H3.85647V5.18398H4.80047C5.22714 5.18398 5.5418 5.08798 5.74447 4.89598C5.9578 4.70398 6.06447 4.42131 6.06447 4.04798C6.06447 3.71731 5.96314 3.46131 5.76047 3.27998C5.5578 3.08798 5.2698 2.99198 4.89647 2.99198C4.42714 2.99198 4.08047 3.10931 3.85647 3.34398C3.63247 3.57865 3.52047 3.93065 3.52047 4.39998H0.640469C0.640469 3.59998 0.800469 2.91731 1.12047 2.35198C1.44047 1.78665 1.9098 1.35465 2.52847 1.05598C3.1578 0.746647 3.91514 0.59198 4.80047 0.59198C5.6858 0.59198 6.4378 0.725314 7.05647 0.991981C7.67514 1.24798 8.14447 1.61065 8.46447 2.07998C8.79514 2.54931 8.96047 3.08798 8.96047 3.69598C8.96047 4.30398 8.7898 4.82131 8.44847 5.24798C8.10714 5.67465 7.64847 5.97865 7.07247 6.15998C7.74447 6.34131 8.25113 6.65065 8.59247 7.08798C8.94447 7.52531 9.12047 8.09598 9.12047 8.79998C9.12047 9.47198 8.94447 10.0693 8.59247 10.592C8.24047 11.104 7.73914 11.504 7.08847 11.792C6.44847 12.0693 5.6858 12.208 4.80047 12.208Z"
                                    fill="#7A63DF"></path>
                            </svg>
                        </span>
                        @lang('Once <strong>they confirm their account</strong> they will be added to your team.')
                    </li>
                </ol>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card text-heading">
            <div class="card-body flex flex-col p-4 px-8 py-6">
                <ul>
                    <li>
                        <a href="#">
                            <img class="h-auto w-full" src="{{ asset('assets/img/team/icon1.png') }}" alt="">
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <img class="h-auto w-full" src="{{ asset('assets/img/team/icon2.png') }}" alt="">
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <img class="h-auto w-full" src="{{ asset('assets/img/team/icon3.png') }}" alt="">
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <img class="h-auto w-full" src="{{ asset('assets/img/team/icon4.png') }}" alt="">
                        </a>
                    </li>
                    <li>
                        <a href="#">
                            <img class="h-auto w-full" src="{{ asset('assets/img/team/icon5.png') }}" alt="">
                        </a>
                    </li>
                </ul>

                <div class="d-flex flex-column align-items-center">

                    <h2 class="" style="text-align: center!important;">@lang('Add your team members’ email address <br> to start collaborating.')
                        📧</h2>
                </div>
                <form action="{{ route('dashboard.user.team.invitation.store', $team->id) }}" method="post">
                    @csrf
                    <input type="hidden" name="team_id" value="{{ $team?->id }}">
                    <div class="relative flex items-center">
                        <input class="form-control @error('email') is-invalid @enderror h-10" id="email"
                            type="email" name="email" placeholder="@lang('Email address')">
                        <span class="absolute !end-0 top-0 flex h-full items-center px-3">
                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_253_1239)">
                                    <path
                                        d="M17.4167 4.58331H4.58333C3.57081 4.58331 2.75 5.40412 2.75 6.41665V15.5833C2.75 16.5958 3.57081 17.4166 4.58333 17.4166H17.4167C18.4292 17.4166 19.25 16.5958 19.25 15.5833V6.41665C19.25 5.40412 18.4292 4.58331 17.4167 4.58331Z"
                                        stroke="currentColor" stroke-width="1.4" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                    <path d="M2.75 6.41669L11 11.9167L19.25 6.41669" stroke="currentColor"
                                        stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round"></path>
                                </g>
                                <defs>
                                    <clipPath id="clip0_253_1239">
                                        <rect width="22" height="22" fill="white"></rect>
                                    </clipPath>
                                </defs>
                            </svg>
                        </span>
                    </div>
                    @if ($app_is_demo)
                        <a class="btn btn-primary w-100 mt-2 rounded-[10px]"
                            onclick="return toastr.info('This feature is disabled in Demo version.')">@lang('Invite Friends')</a>
                    @else
                        <button class="btn btn-primary w-100 mt-2 rounded-[10px]"
                            type="submit">@lang('Invite Friends')</button>
                    @endif

                </form>
            </div>
        </div>
    </div>
</div>
