@extends('panel.layout.app')

@section('title',  __('Team'))

@section('content')
    <div class="page-header">
        <div class="container-xl">
            @include('panel.user.team.partials.header', ['id' => 'team-members'])
        </div>
    </div>
    <!-- Page body -->
    <div class="page-body pt-6">
        <div class="container-xl">
            <div class="row">
                <div class="col-md-5 mx-auto">
                    <div class="header d-flex justify-content-center">
                        @if($user && $user?->avatar)
                            <img   src="{{ asset($user?->avatar) }}" style="width: 150px">
                        @endif

                        <div class="w-100 p-3">
                            <p class="font-bold fs-2">{{ $user?->fullName() }}</p>
							@if($member->joined_at)
								<p>@lang('Member Since') {{ $member->joined_at->format('M d, Y') }}</p>
							@endif
                            <span
                                    class="badge bg- bg-{{ $member->status == 'waiting' ? 'dark font-weight-medium' : ($member->status == 'active' ? 'success' : 'danger') }}"
                            >@lang(strtoupper($member->status))</span>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <p class="fs-1 font-bold">@lang('Your Team Plan')</p>
                            <p>@lang("You have the Team plan which has a remaining balance of <strong class='font-bold font-weight-medium'>:word</strong> words and <strong class='font-bold font-weight-medium'>:image</strong> images.", ['word' => $remaining_words, 'image' => $remaining_images]) </p>
                            <div class="relative">
                                <h3
                                        class="text-[14px] font-normal text-center m-0 absolute top-[calc(50%-5px)] left-1/2 -translate-x-1/2">
                                    <strong class="text-[2em] font-semibold leading-none max-sm:text-[1.5em]">
                                        @if ($remaining_words == -1)
                                            {{ __('Unlimited') }}
                                        @else
                                            {{ number_format((int) $remaining_words) }}
                                        @endif
                                    </strong>
                                    <br>
                                    {{ __('Tokens') }}
                                </h3>
                                <div id="chart-credit"
                                     class="relative [&_.apexcharts-legend-text]:ps-2 [&_.apexcharts-legend-text]:!pe-2 [&_.apexcharts-legend-text]:!m-0">
                                </div>
                            </div>
                        </div>
                    </div>

					<div class="row mt-4 mb-4">
						<div class="col-md-6">
							<div class="card">
								<div class="card-body">
									<label class="mb-3 font-weight-medium">
										@lang('Words Generated') <x-info-tooltip text="{{__('Displays the number of words generated by this team member.')}}" />
									</label>
									<span>{{ $remaining_words }}</span>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="card">
								<div class="card-body">
									<label class="mb-3 font-weight-medium">
										@lang('Images Generated') <x-info-tooltip text="{{__('Displays the number of images generated by this team member.')}}" />
									</label>
									<span>{{ $remaining_images }}</span>
								</div>
							</div>
						</div>
					</div>

					<div class="mb-4 rounded-xl  p-3" style="background-color: rgba(157, 107, 221, 0.1);">
						<p class="fs-2 font-bold font-weight-medium mb-0 pb-0"><span class="ps-2 pe-2 rounded me-2 text-white" style="background-color: rgba(157, 107, 221, 1)">1</span>@lang('Manage User')</p>
					</div>

					<form action="{{ route('dashboard.user.team.member.update', [$team->id, $member->id]) }}" method="post" class="row">
						@csrf
						<div class="col-md-12">
							<div class="mb-3">
								<label class="form-label">{{__('Role')}}</label>
								<input type="text" class="form-control @error('role') is-invalid @enderror" id="role" name="role" value="{{$member->role}}">
								@error('role')
								<div class="invalid-feedback">
									{{ $message }}
								</div>
								@enderror
							</div>
						</div>
						<div class="col-md-12">
							<div class="mb-4">
								<label class="form-label">{{__('Status')}}</label>
								<select class="form-control @error('role') is-invalid @enderror" name="status">
									<option value="active" {{ $member->status == 'active' ? 'selected' : '' }}>@lang('Active')</option>
									<option value="waiting" {{ $member->status == 'waiting' ? 'selected' : '' }}>@lang('Waiting')</option>
									<option value="cancelled" {{ $member->status == 'cancelled' ? 'selected' : '' }}>@lang('Cancelled')</option>
								</select>
								@error('status')
								<div class="invalid-feedback">
									{{ $message }}
								</div>
								@enderror
							</div>
						</div>
						<div class="col-md-12">
							<label class="mb-3 font-weight-medium">
								@lang('Credits') <x-info-tooltip text="{{__('Set unlimited or limited credits for this user.')}}" />
							</label>
							<div class="mb-4">
								<label class="form-check form-switch d-flex justify-content-between">
									<span class="form-check-label me-4 ms-0 ps-0">Allow Unlimited Credits?</span>
									<input class="form-check-input" type="checkbox" id="allow_unlimited_credits" name="allow_unlimited_credits" {{ $member->allow_unlimited_credits ? 'checked' : '' }}>
								</label>
								<small>@lang('If allowed, user will be able to use all credits available in the team package.')</small>
							</div>
						</div>
						<div id="credit_limit_custom" class="col-md-12 {{ old('allow_unlimited_credits', $member->allow_unlimited_credits) ? 'd-none' : '' }}">
							<div class="row">
								<div class="col-md-12">
									<div class="mb-3 ">
										<label class="form-label">
											{{__('Image Credit Limit')}}
											<x-info-tooltip text="{{__('Set a specific image credit limit for this user. This function works only if unlimited credits are disabled.')}}" />
										</label>
										<input type="text" class="form-control @error('remaining_images') is-invalid @enderror" id="remaining_images" name="remaining_images" value="{{$member->remaining_images}}">
										@error('remaining_images')
										<div class="invalid-feedback">
											{{ $message }}
										</div>
										@enderror
									</div>
								</div>
								<div class="col-md-12">
									<div class="mb-3">
										<label class="form-label">
											{{__('Word Credit Limit')}}
											<x-info-tooltip text="{{__('Set a specific word credit limit for this user. This function works only if unlimited credits are disabled.')}}" />
										</label>
										<input type="text" class="form-control @error('remaining_words') is-invalid @enderror" id="remaining_words" name="remaining_words" value="{{$member->remaining_words}}">
										@error('remaining_words')
										<div class="invalid-feedback">
											{{ $message }}
										</div>
										@enderror
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-12">
							<button type="submit" class="btn btn-primary w-100">
								@lang('Save Changes')
							</button>
						</div>
					</form>

                </div>



            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
		// @formatter:off
		document.addEventListener("DOMContentLoaded", function() {
			"use strict";

			$('#allow_unlimited_credits').change(function () {

				let checked = $(this).is(':checked');

				if(checked) {
					$('#credit_limit_custom').addClass('d-none');
				}else {
					$('#credit_limit_custom').removeClass('d-none');
				}
			})

			const options = {
				series: [{{ (int) $remaining_words }}, {{ (int) $total_words }}],
				labels: [@json(__('Remaining')), @json(__('Used'))],
				colors: ['#9A34CD', 'rgba(154,52,205,0.2)'],
				chart: {
					type: 'donut',
					height: 205,
				},
				legend: {
					position: 'bottom',
					fontFamily: 'inherit',
				},
				plotOptions: {
					pie: {
						startAngle: -90,
						endAngle: 90,
						offsetY: 0,
						donut: {
							size: '75%',
						}
					},
				},
				grid: {
					padding: {
						bottom: -130
					}
				},
				stroke: {
					width: 5,
					colors: 'var(--tblr-body-bg)'
				},
				responsive: [{
					breakpoint: 480,
					options: {
						chart: {
							width: 280,
							height: 250
						},
					}
				}],
				dataLabels: {
					enabled: false,
				}
			};
			window.ApexCharts && (new ApexCharts(document.getElementById('chart-credit'), options)).render();
		});
		// @formatter:on
    </script>
@endsection